package gov.va.vamf.scheduling.facility.dataservice;

import gov.va.vamf.scheduling.facility.datalayer.FacilityFilter;
import gov.va.vamf.scheduling.facility.domain.CDWFacilities;
import gov.va.vamf.scheduling.facility.domain.CDWFacility;
import gov.va.vamf.scheduling.facility.datalayer.CdwFacilityDataLayer;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.ArrayList;

@Component
public class FacilityDataService {

    @Resource
    CdwFacilityDataLayer facilityDataLayer;

    public CDWFacilities fetchFacilities(FacilityFilter facilityFilter) {
        Map<Integer, CDWFacilities> facilities = facilityFilter.filter();

        CDWFacilities result = new CDWFacilities();

        //we need to convert filtered results of the cache to CDWFacilities with children set
        for (Integer key : facilities.keySet()) {
            CDWFacility parentFacility = new CDWFacility();
            ArrayList<CDWFacility> children = new ArrayList<CDWFacility>();

            for (CDWFacility facility : facilities.get(key)) {
                //when: the parent site code matches the facility code
                //then: this facility is a parent facility and set the parent facility to this facility
                //else: this facility is a child facility and add it to my children
                if (facility.getParentSiteCode().equals(facility.getFacilityCode())) {
                    parentFacility = facility;
                } else {
                    children.add(facility);
                }
            }

            parentFacility.setChildren(children);
            result.add(parentFacility);
        }

        return result;
    }
}
